using System;
using System.Collections;
using Server;
using Server.Items;
using Server.Engines.Craft;
using System.Collections.Generic;


namespace Server.Engines.BulkOrders
{
	[TypeAlias( "Scripts.Engines.BulkOrders.SmallFletcherBOD" )]
	public class SmallFletcherBOD : SmallBOD
	{
		public static double[] m_FletchingMaterialChances = new double[]
			{
				0.190, // None
				0.120, // Pine
				0.110, // Cedar
				0.100, // Cherry
				0.090, // Mahogany
				0.080, // Oak
				0.070, // Ash
				0.060, // Yew
				0.050, // Heartwood
				0.040, // Bloodwood
				0.030, // Frostwood
			};

		public override int ComputeFame()
		{
			return FletcherRewardCalculator.Instance.ComputeFame( this );
		}

		public override int ComputeGold()
		{
			return FletcherRewardCalculator.Instance.ComputeGold( this );
		}

		public override List<Item> ComputeRewards( bool full )
		{
			List<Item> list = new List<Item>();

			RewardGroup rewardGroup = FletcherRewardCalculator.Instance.LookupRewards( FletcherRewardCalculator.Instance.ComputePoints( this ) );

			if ( rewardGroup != null )
			{
				if ( full )
				{
					for ( int i = 0; i < rewardGroup.Items.Length; ++i )
					{
						Item item = rewardGroup.Items[i].Construct();

						if ( item != null )
							list.Add( item );
					}
				}
				else
				{
					RewardItem rewardItem = rewardGroup.AcquireItem();

					if ( rewardItem != null )
					{
						Item item = rewardItem.Construct();

						if ( item != null )
							list.Add( item );
					}
				}
			}

			return list;
		}

		public static SmallFletcherBOD CreateRandomFor( Mobile m )
		{
			SmallBulkEntry[] entries;
			bool useMaterials;

			if ( useMaterials = Utility.RandomBool() )
				entries = SmallBulkEntry.FletcherAllBow;
			else
				entries = SmallBulkEntry.FletcherAllBow;

			if ( entries.Length > 0 )
			{
				double theirSkill = m.Skills[SkillName.Fletching].Base;
				int amountMax;

				if ( theirSkill >= 70.1 )
					amountMax = Utility.RandomList( 10, 15, 20, 20 );
				else if ( theirSkill >= 50.1 )
					amountMax = Utility.RandomList( 10, 15, 15, 20 );
				else
					amountMax = Utility.RandomList( 10, 10, 15, 20 );

				BulkMaterialType material = BulkMaterialType.None;

				if ( useMaterials && theirSkill >= 70.1 )
				{
					for ( int i = 0; i < 20; ++i )
					{
						BulkMaterialType check = GetRandomMaterial( BulkMaterialType.Pine, m_FletchingMaterialChances );
						double skillReq = 0.0;

						switch ( check )
						{
							case BulkMaterialType.DullCopper: skillReq = 40.0; break;
							case BulkMaterialType.ShadowIron: skillReq = 45.0; break;
							case BulkMaterialType.Copper: skillReq = 50.0; break;
							case BulkMaterialType.Bronze: skillReq = 55.0; break;
							case BulkMaterialType.Gold: skillReq = 60.0; break;
							case BulkMaterialType.Agapite: skillReq = 65.0; break;
							case BulkMaterialType.Verite: skillReq = 70.0; break;
							case BulkMaterialType.Valorite: skillReq = 75.0; break;
							case BulkMaterialType.Silver: skillReq = 80.0; break;
							case BulkMaterialType.Platinum: skillReq = 85.0; break;
							case BulkMaterialType.Mythril: skillReq = 90.0; break;
							case BulkMaterialType.Obsidian: skillReq = 95.0; break;
							case BulkMaterialType.Jade: skillReq = 100.0; break;
							case BulkMaterialType.Moonstone: skillReq = 105.0; break;
							case BulkMaterialType.Sunstone: skillReq = 110.0; break;
							case BulkMaterialType.Bloodstone: skillReq = 115.0; break;
							case BulkMaterialType.Spined: skillReq = 65.0; break;
							case BulkMaterialType.Horned: skillReq = 80.0; break;
							case BulkMaterialType.Barbed: skillReq = 100.0; break;
							case BulkMaterialType.DragonL: skillReq = 105.0; break;
							case BulkMaterialType.Daemon: skillReq = 115.0; break;
							case BulkMaterialType.Pine:			skillReq = 35.0; break;
							case BulkMaterialType.Cedar:			skillReq = 45.0; break;
							case BulkMaterialType.Cherry:		skillReq = 75.0; break;
							case BulkMaterialType.Mahogany:			skillReq = 85.0; break;
							case BulkMaterialType.Oak:			skillReq = 90.0; break;
							case BulkMaterialType.Ash:			skillReq = 95.0; break;
							case BulkMaterialType.Yew:			skillReq = 100.0; break;
							case BulkMaterialType.Heartwood:			skillReq = 105.0; break;
							case BulkMaterialType.Bloodwood:			skillReq = 110.0; break;
							case BulkMaterialType.Frostwood:			skillReq = 115.0; break;
						}

						if ( theirSkill >= skillReq )
						{
							material = check;
							break;
						}
					}
				}

				double excChance = 0.0;

				if ( theirSkill >= 70.1 )
					excChance = (theirSkill + 80.0) / 200.0;

				bool reqExceptional = ( excChance > Utility.RandomDouble() );

				SmallBulkEntry entry = null;

				CraftSystem system = DefBowFletching.CraftSystem;

				for ( int i = 0; i < 150; ++i )
				{
					SmallBulkEntry check = entries[Utility.Random( entries.Length )];

					CraftItem item = system.CraftItems.SearchFor( check.Type );

					if ( item != null )
					{
						bool allRequiredSkills = true;
						double chance = item.GetSuccessChance( m, null, system, false, ref allRequiredSkills );

						if ( allRequiredSkills && chance >= 0.0 )
						{
							if ( reqExceptional )
								chance = item.GetExceptionalChance( system, chance, m );

							if ( chance > 0.0 )
							{
								entry = check;
								break;
							}
						}
					}
				}

				if ( entry != null )
					return new SmallFletcherBOD( entry, material, amountMax, reqExceptional );
			}

			return null;
		}

		private SmallFletcherBOD( SmallBulkEntry entry, BulkMaterialType material, int amountMax, bool reqExceptional )
		{
			this.Hue = 0x58;
			this.AmountMax = amountMax;
			this.Type = entry.Type;
			this.Number = entry.Number;
			this.Graphic = entry.Graphic;
			this.RequireExceptional = reqExceptional;
			this.Material = material;
		}
		
      [Constructable]
		public SmallFletcherBOD( BulkMaterialType material, int amountMax, bool reqExceptional, LargeBulkEntry entry )
		{
			this.Hue = 0x58;
			this.AmountMax = amountMax;
			this.Type = entry.Details.Type;
			this.Number = entry.Details.Number;
			this.Graphic = entry.Details.Graphic;
			this.RequireExceptional = reqExceptional;
			this.Material = material;
		}

		[Constructable]
		public SmallFletcherBOD()
		{
			SmallBulkEntry[] entries;
			bool useMaterials;

			if ( useMaterials = Utility.RandomBool() )
				entries = SmallBulkEntry.FletcherAllBow;
			else
				entries = SmallBulkEntry.FletcherAllBow;

			if ( entries.Length > 0 )
			{
				int hue = 0x58;
				int amountMax = Utility.RandomList( 10, 15, 20 );

				BulkMaterialType material;

				if ( useMaterials )
					material = GetRandomMaterial( BulkMaterialType.Pine, m_FletchingMaterialChances );
				else
					material = BulkMaterialType.None;

				bool reqExceptional = Utility.RandomBool() || (material == BulkMaterialType.None);

				SmallBulkEntry entry = entries[Utility.Random( entries.Length )];

				this.Hue = hue;
				this.AmountMax = amountMax;
				this.Type = entry.Type;
				this.Number = entry.Number;
				this.Graphic = entry.Graphic;
				this.RequireExceptional = reqExceptional;
				this.Material = material;
			}
		}

		public SmallFletcherBOD( int amountCur, int amountMax, Type type, int number, int graphic, bool reqExceptional, BulkMaterialType mat )
		{
			this.Hue = 0x58;
			this.AmountMax = amountMax;
			this.AmountCur = amountCur;
			this.Type = type;
			this.Number = number;
			this.Graphic = graphic;
			this.RequireExceptional = reqExceptional;
			this.Material = mat;
		}

		public SmallFletcherBOD( Serial serial ) : base( serial )
		{
		}

		public override void Serialize( GenericWriter writer )
		{
			base.Serialize( writer );

			writer.Write( (int) 0 ); // version
		}

		public override void Deserialize( GenericReader reader )
		{
			base.Deserialize( reader );

			int version = reader.ReadInt();
		}
	}
}
